<?php
global 	$directory_url;
$directory_url=get_option('_iv_directory_url');
if($directory_url==""){$directory_url='directories';}

	
function dirpro_taxonomy_add_custom_field() {
    ?>
    <div class="form-field term-image-wrap">
        <label for="cat-image"><?php esc_html_e('Image','ivdirectories');?></label>
        <p><a href="#" class="aw_upload_image_button button button-secondary" id="upload_image_btn"><?php esc_html_e('Upload Image','ivdirectories');?></a></p>
        <input type="text" name="category_image_url" id="category_image_url"  value="" size="40" />
    </div>
    <?php
}
add_action( $directory_url.'-locations_add_form_fields', 'dirpro_taxonomy_add_custom_field', 10, 2 );
 
function dirpro_taxonomy_edit_custom_field($term) {
    $image = get_term_meta($term->term_id, 'dirpro_term_image', true);
    ?>
    <tr class="form-field term-image-wrap">
        <th scope="row"><label for="category_image_url"><?php esc_html_e('Image','ivdirectories');?></label></th>
        <td>
            <p><a href="#" class="aw_upload_image_button button button-secondary" id="upload_image_btn"><?php esc_html_e('Upload Image','ivdirectories');?> </a>
				
				<img src="<?php echo esc_url($image); ?>" id="dirpro_term_image_dis" width="100px">
			</p>
			
			<br/>
            <input type="text" name="category_image_url"  id="category_image_url" value="<?php echo esc_url($image); ?>" size="40" />
        </td>
    </tr>
    <?php
}
add_action( $directory_url.'-locations_edit_form_fields', 'dirpro_taxonomy_edit_custom_field', 10, 2 );

// Save data
add_action('created_'.$directory_url.'-locations', 'dirpro_save_term_image', 10, 2);
function dirpro_save_term_image($term_id, $tt_id) {
    if (isset($_POST['category_image_url']) && '' !== $_POST['category_image_url']){
        $group = sanitize_url($_POST['category_image_url']);
        add_term_meta($term_id, 'dirpro_term_image', $group, true);
    }
}

///Now save the edited value
add_action('edited_'.$directory_url.'-locations', 'dirpro_update_image_upload', 10, 2);
function dirpro_update_image_upload($term_id, $tt_id) {
    if (isset($_POST['category_image_url']) && '' !== $_POST['category_image_url']){
        $group = sanitize_url($_POST['category_image_url']);
        update_term_meta($term_id, 'dirpro_term_image', $group);
    }
}

// Js add
function dirpro_image_uploader_enqueue() {
    global $typenow,$directory_url;	
    if( ($typenow == $directory_url) ) { 
		wp_enqueue_media();
        wp_register_script( 'dirpro_meta-image', wp_iv_directories_URLPATH . 'admin/files/js/meta-media-uploader.js', array( 'jquery' ) );
        wp_localize_script( 'dirpro_meta-image', 'meta_image',
            array(
                'title' => 'Upload an Image',
                'button' => 'Use this Image',
            )
        );
        wp_enqueue_script( 'dirpro_meta-image' );
    }
}
add_action( 'admin_enqueue_scripts', 'dirpro_image_uploader_enqueue' );